/*
 * Decompiled with CFR 0.152.
 */
package tv.mapper.roadstuff.world.level.block;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.tuple.Pair;
import tv.mapper.mapperbase.world.level.block.CustomBlock;
import tv.mapper.mapperbase.world.level.block.CustomFenceBlock;
import tv.mapper.mapperbase.world.level.block.CustomFenceGateBlock;
import tv.mapper.mapperbase.world.level.block.CustomOreBlock;
import tv.mapper.mapperbase.world.level.block.CustomPressurePlateBlock;
import tv.mapper.mapperbase.world.level.block.CustomSlabBlock;
import tv.mapper.mapperbase.world.level.block.CustomStairsBlock;
import tv.mapper.mapperbase.world.level.block.CustomWallBlock;
import tv.mapper.mapperbase.world.level.block.ToolTypes;
import tv.mapper.roadstuff.world.level.block.BollardBlock;
import tv.mapper.roadstuff.world.level.block.ConeBlock;
import tv.mapper.roadstuff.world.level.block.CylindricalBollardBlock;
import tv.mapper.roadstuff.world.level.block.GuardrailBlock;
import tv.mapper.roadstuff.world.level.block.PaintBucketBlock;
import tv.mapper.roadstuff.world.level.block.PaintableRoadBlock;
import tv.mapper.roadstuff.world.level.block.PaintableSlopeBlock;
import tv.mapper.roadstuff.world.level.block.ReflectorBlock;
import tv.mapper.roadstuff.world.level.block.RotatablePaintBlock;
import tv.mapper.roadstuff.world.level.block.RotatableSlopeBlock;

public class RSBlockRegistry {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"roadstuff");
    public static Set<RegistryObject<Block>> MOD_PAINTABLEBLOCKS = new LinkedHashSet<RegistryObject<Block>>();
    private static BlockBehaviour.Properties concreteProperties = BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76409_).m_60913_(1.5f, 6.0f).m_60918_(SoundType.f_56742_).m_60999_();
    private static BlockBehaviour.Properties asphaltProperties = BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76365_).m_60913_(1.5f, 6.0f).m_60918_(SoundType.f_56742_).m_60999_();
    private static BlockBehaviour.Properties bollardProperties = BlockBehaviour.Properties.m_60944_((Material)Material.f_76310_, (MaterialColor)MaterialColor.f_76412_).m_60913_(0.1f, 3.0f).m_60918_(SoundType.f_56754_).m_60999_();
    public static final RegistryObject<PaintableRoadBlock> CONCRETE = BLOCKS.register("concrete", () -> new PaintableRoadBlock(concreteProperties, ToolTypes.PICKAXE, 1));
    public static final RegistryObject<CustomStairsBlock> CONCRETE_STAIRS = BLOCKS.register("concrete_stairs", () -> new CustomStairsBlock(() -> ((PaintableRoadBlock)CONCRETE.get()).m_49966_(), concreteProperties, ToolTypes.PICKAXE));
    public static final RegistryObject<CustomSlabBlock> CONCRETE_SLAB = BLOCKS.register("concrete_slab", () -> new CustomSlabBlock(concreteProperties, ToolTypes.PICKAXE));
    public static final RegistryObject<CustomWallBlock> CONCRETE_WALL = BLOCKS.register("concrete_wall", () -> new CustomWallBlock(concreteProperties, ToolTypes.PICKAXE));
    public static final RegistryObject<CustomFenceBlock> CONCRETE_FENCE = BLOCKS.register("concrete_fence", () -> new CustomFenceBlock(concreteProperties, ToolTypes.PICKAXE));
    public static final RegistryObject<CustomFenceGateBlock> CONCRETE_FENCE_GATE = BLOCKS.register("concrete_fence_gate", () -> new CustomFenceGateBlock(concreteProperties, ToolTypes.PICKAXE));
    public static final RegistryObject<PaintableRoadBlock> ASPHALT = BLOCKS.register("asphalt", () -> new PaintableRoadBlock(asphaltProperties, ToolTypes.PICKAXE, 0));
    public static final RegistryObject<CustomStairsBlock> ASPHALT_STAIRS = BLOCKS.register("asphalt_stairs", () -> new CustomStairsBlock(() -> ((PaintableRoadBlock)ASPHALT.get()).m_49966_(), asphaltProperties, ToolTypes.PICKAXE));
    public static final RegistryObject<CustomSlabBlock> ASPHALT_SLAB = BLOCKS.register("asphalt_slab", () -> new CustomSlabBlock(asphaltProperties, ToolTypes.PICKAXE));
    public static final RegistryObject<PaintableSlopeBlock> ASPHALT_SLOPE = BLOCKS.register("asphalt_slope", () -> new PaintableSlopeBlock(asphaltProperties, ToolTypes.PICKAXE, 0));
    public static final RegistryObject<PaintableSlopeBlock> CONCRETE_SLOPE = BLOCKS.register("concrete_slope", () -> new PaintableSlopeBlock(concreteProperties, ToolTypes.PICKAXE, 1));
    public static final RegistryObject<CustomBlock> BITUMEN_BLOCK;
    public static final RegistryObject<CustomOreBlock> BITUMEN_ORE;
    public static final Map<DyeColor, RegistryObject<ConeBlock>> TRAFFIC_CONE_BLOCKS;
    public static final Map<DyeColor, RegistryObject<ConeBlock>> TRAFFIC_BARREL_BLOCKS;
    public static final Map<DyeColor, RegistryObject<ConeBlock>> TRAFFIC_BOLLARD_BLOCKS;
    public static final Map<DyeColor, RegistryObject<CylindricalBollardBlock>> CYLINDRICAL_BOLLARD_BLOCKS;
    public static final RegistryObject<BollardBlock> YELLOW_BOLLARD;
    public static final RegistryObject<BollardBlock> WHITE_BOLLARD;
    public static final RegistryObject<BollardBlock> RED_BOLLARD;
    public static final RegistryObject<BollardBlock> YELLOW_SMALL_BOLLARD;
    public static final RegistryObject<BollardBlock> WHITE_SMALL_BOLLARD;
    public static final RegistryObject<BollardBlock> RED_SMALL_BOLLARD;
    public static final Map<DyeColor, RegistryObject<ReflectorBlock>> REFLECTOR_BLOCKS;
    public static final Map<DyeColor, RegistryObject<ReflectorBlock>> LUMINESCENT_REFLECTOR_BLOCKS;
    public static final RegistryObject<GuardrailBlock> STEEL_GUARDRAIL;
    public static final Map<DyeColor, RegistryObject<GuardrailBlock>> GUARDRAIL_BLOCKS;
    public static final RegistryObject<PaintBucketBlock> PAINT_BUCKET;
    public static final RegistryObject<CustomPressurePlateBlock> ASPHALT_PRESSURE_PLATE;
    public static final RegistryObject<CustomPressurePlateBlock> CONCRETE_PRESSURE_PLATE;

    public static void init() {
        BLOCKS.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    static {
        for (int i = 1; i < 324; ++i) {
            MOD_PAINTABLEBLOCKS.add((RegistryObject<Block>)BLOCKS.register("asphalt_white_line_" + i, () -> new RotatablePaintBlock(asphaltProperties, ToolTypes.PICKAXE, 0)));
            MOD_PAINTABLEBLOCKS.add((RegistryObject<Block>)BLOCKS.register("asphalt_yellow_line_" + i, () -> new RotatablePaintBlock(asphaltProperties, ToolTypes.PICKAXE, 0)));
            MOD_PAINTABLEBLOCKS.add((RegistryObject<Block>)BLOCKS.register("concrete_white_line_" + i, () -> new RotatablePaintBlock(concreteProperties, ToolTypes.PICKAXE, 1)));
            MOD_PAINTABLEBLOCKS.add((RegistryObject<Block>)BLOCKS.register("concrete_yellow_line_" + i, () -> new RotatablePaintBlock(concreteProperties, ToolTypes.PICKAXE, 1)));
            MOD_PAINTABLEBLOCKS.add((RegistryObject<Block>)BLOCKS.register("asphalt_slope_white_line_" + i, () -> new RotatableSlopeBlock(asphaltProperties, (Block)ASPHALT_SLOPE.get(), ToolTypes.PICKAXE, 0)));
            MOD_PAINTABLEBLOCKS.add((RegistryObject<Block>)BLOCKS.register("asphalt_slope_yellow_line_" + i, () -> new RotatableSlopeBlock(asphaltProperties, (Block)ASPHALT_SLOPE.get(), ToolTypes.PICKAXE, 0)));
            MOD_PAINTABLEBLOCKS.add((RegistryObject<Block>)BLOCKS.register("concrete_slope_white_line_" + i, () -> new RotatableSlopeBlock(concreteProperties, (Block)CONCRETE_SLOPE.get(), ToolTypes.PICKAXE, 1)));
            MOD_PAINTABLEBLOCKS.add((RegistryObject<Block>)BLOCKS.register("concrete_slope_yellow_line_" + i, () -> new RotatableSlopeBlock(concreteProperties, (Block)CONCRETE_SLOPE.get(), ToolTypes.PICKAXE, 1)));
        }
        BITUMEN_BLOCK = BLOCKS.register("bitumen_block", () -> new CustomBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76365_).m_60978_(3.0f).m_60999_(), ToolTypes.PICKAXE));
        BITUMEN_ORE = BLOCKS.register("bitumen_ore", () -> new CustomOreBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76365_).m_60978_(3.0f).m_60999_(), UniformInt.m_146622_((int)0, (int)1), ToolTypes.PICKAXE));
        TRAFFIC_CONE_BLOCKS = Arrays.stream(DyeColor.values()).map(type -> Pair.of((Object)type, (Object)BLOCKS.register(type.m_7912_() + "_traffic_cone", () -> new ConeBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76310_, (MaterialColor)type.m_41069_()).m_60913_(0.1f, 3.0f).m_60918_(SoundType.f_56754_), ToolTypes.NONE, ConeBlock.EnumConeType.CONE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
        TRAFFIC_BARREL_BLOCKS = Arrays.stream(DyeColor.values()).map(type -> Pair.of((Object)type, (Object)BLOCKS.register(type.m_7912_() + "_traffic_barrel", () -> new ConeBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76310_, (MaterialColor)type.m_41069_()).m_60913_(0.1f, 3.0f).m_60918_(SoundType.f_56754_), ToolTypes.NONE, ConeBlock.EnumConeType.BARREL)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
        TRAFFIC_BOLLARD_BLOCKS = Arrays.stream(DyeColor.values()).map(type -> Pair.of((Object)type, (Object)BLOCKS.register(type.m_7912_() + "_traffic_bollard", () -> new ConeBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76310_, (MaterialColor)type.m_41069_()).m_60913_(0.1f, 3.0f).m_60918_(SoundType.f_56754_), ToolTypes.NONE, ConeBlock.EnumConeType.BOLLARD)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
        CYLINDRICAL_BOLLARD_BLOCKS = Arrays.stream(DyeColor.values()).map(type -> Pair.of((Object)type, (Object)BLOCKS.register(type.m_7912_() + "_cylindrical_bollard", () -> new CylindricalBollardBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76310_, (MaterialColor)type.m_41069_()).m_60913_(0.1f, 3.0f).m_60918_(SoundType.f_56754_), ToolTypes.NONE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
        YELLOW_BOLLARD = BLOCKS.register("yellow_bollard", () -> new BollardBlock(bollardProperties, ToolTypes.NONE, false));
        WHITE_BOLLARD = BLOCKS.register("white_bollard", () -> new BollardBlock(bollardProperties, ToolTypes.NONE, false));
        RED_BOLLARD = BLOCKS.register("red_bollard", () -> new BollardBlock(bollardProperties, ToolTypes.NONE, false));
        YELLOW_SMALL_BOLLARD = BLOCKS.register("yellow_small_bollard", () -> new BollardBlock(bollardProperties, ToolTypes.NONE, true));
        WHITE_SMALL_BOLLARD = BLOCKS.register("white_small_bollard", () -> new BollardBlock(bollardProperties, ToolTypes.NONE, true));
        RED_SMALL_BOLLARD = BLOCKS.register("red_small_bollard", () -> new BollardBlock(bollardProperties, ToolTypes.NONE, true));
        REFLECTOR_BLOCKS = Arrays.stream(DyeColor.values()).map(type -> Pair.of((Object)type, (Object)BLOCKS.register(type.m_7912_() + "_reflector", () -> new ReflectorBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76310_, (MaterialColor)type.m_41069_()).m_60913_(0.1f, 3.0f).m_60918_(SoundType.f_56743_), ToolTypes.NONE, false)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
        LUMINESCENT_REFLECTOR_BLOCKS = Arrays.stream(DyeColor.values()).map(type -> Pair.of((Object)type, (Object)BLOCKS.register(type.m_7912_() + "_luminescent_reflector", () -> new ReflectorBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76310_, (MaterialColor)type.m_41069_()).m_60913_(0.1f, 3.0f).m_60953_(state -> 14).m_60918_(SoundType.f_56743_), ToolTypes.NONE, true)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
        STEEL_GUARDRAIL = BLOCKS.register("steel_guardrail", () -> new GuardrailBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76419_).m_60978_(3.0f).m_60918_(SoundType.f_56762_), ToolTypes.PICKAXE));
        GUARDRAIL_BLOCKS = Arrays.stream(DyeColor.values()).map(type -> Pair.of((Object)type, (Object)BLOCKS.register(type.m_7912_() + "_guardrail", () -> new GuardrailBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)type.m_41069_()).m_60978_(3.0f).m_60918_(SoundType.f_56762_), ToolTypes.PICKAXE)))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
        PAINT_BUCKET = BLOCKS.register("paint_bucket", () -> new PaintBucketBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76419_).m_60913_(0.5f, 3.0f).m_60918_(SoundType.f_56762_), ToolTypes.PICKAXE));
        ASPHALT_PRESSURE_PLATE = BLOCKS.register("asphalt_pressure_plate", () -> new CustomPressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, asphaltProperties.m_60910_(), ToolTypes.PICKAXE));
        CONCRETE_PRESSURE_PLATE = BLOCKS.register("concrete_pressure_plate", () -> new CustomPressurePlateBlock(PressurePlateBlock.Sensitivity.MOBS, concreteProperties.m_60910_(), ToolTypes.PICKAXE));
    }
}

